unit mVimmSelect;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, System.UITypes, VCL.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVimmBase, Vcl.StdCtrls, Vcl.ExtCtrls, mVimmEdit, ORCtrls, ORFn, rVimm,
  Vcl.ImgList, Vcl.Buttons, System.ImageList, Vcl.ComCtrls;

type
  TfraVimmSelect = class(TfraParent)
    rgpDocumentation: TRadioGroup;
    lblImm: TLabel;
    cboImm: TORComboBox;
    gridPanel: TGridPanel;
    pnlImm: TPanel;

    procedure rgpDocumentationClick(Sender: TObject);
    procedure cboImmClick(Sender: TObject);
    procedure rgpDocumentationEnter(Sender: TObject);
    procedure btnExpandCollapseClick(Sender: TObject);
  private
    { Private declarations }
    adminDate: TFMDateTime;
    remId: string;
    iceData: string;
    patientIEN: string;
    editingRecord : boolean;
    function getDocumentType: string;
    function getLayoutValue: integer;
    procedure selectPage(data: string; details, edit: boolean);
    function getEditControl: TControl;
    function performCheck(immunization, patient: string): integer;
    function isActiveLookup: boolean;
  protected
    isEditing: boolean;
  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    procedure setSelectionType(isSkin: boolean);
    procedure startEdits(data: string = ''; details: boolean = false; edit: boolean = true);
    function startEditsFromMain(data: string; edit: boolean): boolean;
    function setEditFields(immunization: string): boolean;
    procedure collapse;
    procedure expand;
    procedure disableImmLookup;
    procedure clearFields;
    procedure setEncounterData(date: TFMDateTime; patient: string; isSkin: boolean);
    procedure startFromReminders(input: string);
    procedure startFromIce(input: string);
    function canChange(input, inputType: string): boolean;
  end;

var
  fraVimmSelect: TfraVimmSelect;

implementation

{$R *.dfm}
var
tempImm: string;
isSkinTest: boolean;

procedure TfraVimmSelect.btnExpandCollapseClick(Sender: TObject);
var
text: string;
begin
  inherited;
  text := '';
  if fCollapsed then
    begin
      if self.cboImm.ItemIndex > -1 then
        text := Piece(self.cboImm.Items.Strings[cboImm.ItemIndex], U, 2);
      if self.rgpDocumentation.ItemIndex > -1 then
        text := text + ' ' +  Copy(rgpDocumentation.Items.Strings[rgpDocumentation.ItemIndex], 2,
        Length(rgpDocumentation.Items.Strings[rgpDocumentation.ItemIndex]));
      if text <> '' then text := text + ' ' + 'documentation';
      if uVimmInputs.immunizationReading then text := 'Smallpox reading documentation';

    end;
   lblHeader.Caption := text;
end;

function TfraVimmSelect.canChange(input, inputType: string): boolean;
begin
  result := true;
  if inputType <> 'rem' then exit;

  if isEditing and (RemID <> '') and (RemID <> Input) then
    begin
    if InfoBox('Currently editing a record. All data will be lost if you continue.' + CRLF + CRLF+
    'Click Yes to Continue.', 'WARNING', MB_YESNO) = IDNO then
      begin
        rgpDocumentation.ItemIndex := rgpDocumentation.Tag;
        result := false;
        exit;
      end
      else
        begin
          clearFields;
        end;
    end;
end;

procedure TfraVimmSelect.cboImmClick(Sender: TObject);
var
tmp: string;
begin
  inherited;
  if cboImm.itemIndex = -1 then exit;
  tmp := cboImm.Items.Strings[cboImm.ItemIndex];
  selectPage(tmp, false, false);
end;

procedure TfraVimmSelect.clearFields;
begin
  if isEditing then
    begin
      cboImm.itemIndex := -1;
      cboImm.text := '';
      cboImm.Enabled := false;
      rgpDocumentation.ItemIndex := -1;
      isEditing := false;
      rgpDocumentation.Enabled := false;
    end;
end;

procedure TfraVimmSelect.collapse;
begin
  if not fCollapsed then btnExpandCollapseClick(self);
end;

constructor TfraVimmSelect.Create(aOwner: TComponent);
begin
  inherited;
  style := ssAbsolute;
  minValue := pnlWorkspace.Top + pnlWorkspace.Height;
  isEditing := false;
//  if isSkin then

end;

procedure TfraVimmSelect.disableImmLookup;
begin
  cboImm.Enabled := false;
end;

procedure TfraVimmSelect.expand;
begin
  if fCollapsed then btnExpandCollapseClick(self);
end;

//get the edit frame control. Always the last row in the parent grid panel
function TfraVimmSelect.getDocumentType: string;
begin
  if not isSkinTest then
    begin
      if uVimmInputs.isFromEncounter then
        begin
          if uVimmInputs.isHistorical then
            begin
              case rgpDocumentation.ItemIndex of
                0: result := 'Historical';
                1: result := 'Contraindication';
                2: result := 'Result';
              end;
            end
          else begin
            case rgpDocumentation.ItemIndex of
              0: result := 'Administered';
              1: result := 'Contraindication';
              2: result := 'Result';
            end;
          end;
        end
      else
        begin
          case rgpDocumentation.ItemIndex of
            0: result := 'Administered';
            1: result := 'Historical';
            2: result := 'Contraindication';
            3: result := 'Result';
          end;
        end;
    end;
    if uVimmInputs.isFromEncounter then
      begin
        if uVimmInputs.isHistorical then
          begin
            case rgpDocumentation.ItemIndex of
              0: result := 'Historical';
            end;
          end
        else begin
          case rgpDocumentation.ItemIndex of
            0: result := 'Administered';
            1: result := 'Reading';
          end;
        end;
      end
    else
      begin
        case rgpDocumentation.ItemIndex of
          0: result := 'Administered';
          1: result := 'Reading';
          2: result := 'Historical';
        end;
      end;


end;

function TfraVimmSelect.getEditControl: TControl;
var
grid: TGridPanel;
begin
    grid := TGridPanel(self.Parent);
    result := grid.ControlCollection.Controls[0, grid.RowCollection.Count - 1];
end;

function TfraVimmSelect.getLayoutValue: integer;
begin
 if isSkinTest then
  begin
    if uVimmInputs.isFromEncounter and uVimmInputs.isHistorical then
      result := 2
    else result := rgpDocumentation.ItemIndex;
  end
 else
  begin
    if uVimmInputs.isFromEncounter then
      begin
        if uVimmInputs.isHistorical then result := rgpDocumentation.ItemIndex + 1
        else
          begin
            if rgpDocumentation.ItemIndex = 0 then result := 0
            else result := rgpDocumentation.ItemIndex + 1
          end;
      end
    else result := rgpDocumentation.ItemIndex;
  end;

end;

function TfraVimmSelect.isActiveLookup: boolean;
var
idx: integer;
begin
   idx := rgpDocumentation.ItemIndex;
   if idx > 0 then result := false
   else if uVimmInputs.isFromEncounter then
    begin
      if uVimmInputs.isHistorical then result := false
      else result := true
    end
   else result := true;
end;

//check per documenting an administration of an immunization if patient has an refusal or a
//contraindication on file
function TfraVimmSelect.performCheck(immunization, patient: string): integer;
var
warn, warn1: string;
begin
  // result = 0 no warning display, -1 user cancel the process, 1 user ok the warning continue the process
  result := 0;
  warn1 := 'Click Ok to continue or Cancel to Quit';
  if (self.rgpDocumentation.ItemIndex = 0) and (Pos('Admin', self.rgpDocumentation.Items[0])>0) then
    begin
      warn := checkForWarning(patient, immunization, self.adminDate);
      if warn <> '' then
        begin
          if messageDlg(warn + CRLF + CRLF + warn1, mtWarning, [mbOK, mbCancel], 0) = mrCancel then result := -1
          else result := 1;
        end;
    end;
end;

procedure TfraVimmSelect.rgpDocumentationClick(Sender: TObject);
var
tmpList: TStringList;
aControl: TControl;
idx: integer;
name, orgImm: string;
isDisable: boolean;
begin
  tmpList := TStringList.Create;
  try
    //prompt for warning when changing documentation status and in the middle of an edit process
    if isEditing and ((rgpDocumentation.Tag > -1) and  (rgpDocumentation.ItemIndex <> rgpDocumentation.Tag)) and
    (InfoBox('Currently editing a record. All data will be lost if you continue.' + CRLF + CRLF+
    'Click Yes to Continue.', 'WARNING', MB_YESNO) = IDNO) then
      begin
        rgpDocumentation.ItemIndex := rgpDocumentation.Tag;
        exit;
      end;
    isDisable := cboImm.Enabled = false;
    if rgpDocumentation.ItemIndex > -1 then cboImm.Enabled := true;
    if rgpDocumentation.Tag > -1 then
      begin
        aControl := getEditControl;
//        TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgBlank, 'blank', false, false)
        TFraImmEdit(aControl).createLayout(-1, '', '', false, false);
      end;
    rgpDocumentation.Tag := rgpDocumentation.ItemIndex;
    if isDisable then orgImm := cboImm.Text;

    cboImm.ItemIndex := -1;
    cboImm.Text := '';
    cboImm.Items.Clear;
    if isSkinTest and (rgpDocumentation.ItemIndex = 1) and (not editingRecord) then
      begin
        if not placementsOnFile then
          begin
            ShowMessage('No open placments on file to read.' + CRLF + 'Select historical to document an outside reading');
            exit;
          end;

      end;
    if isSkinTest and (remId <> '') then getSubSetData(tmpList, 'rem', remId)
    else if isSkinTest then getShortActiveLookup(tmpList, true, not editingRecord)
    else if iceData <> '' then getSubSetData(tmpList, 'ice', iceData)
    else if remId <> '' then getSubSetData(tmpList, 'rem', remId)
    else if isActiveLookup then getShortActiveLookup(tmpList, false, false)
    else getShortHistoricalLookup(tmpList);
    if isSkinTest and uVimmInputs.hasPlacements then cboImm.Sorted := false
    else cboImm.Sorted := true;

    FastAssign(tmpList, cboImm.Items);
    if cboImm.Items.Count = 1 then
      begin
        cboImm.ItemIndex := 0;
        cboImm.OnClick(cboImm);
      end;
    if isDisable then
      begin
        cboImm.Enabled := true;
        idx := cboImm.Items.IndexOf(orgImm);
        if idx > 0 then
          begin
            cboImm.ItemIndex := idx;
            cboImm.OnClick(cboImm);
            cboImm.Enabled := false;
          end;
      end;

    //tempIMM defined when calling the calling the frame with an immunization but no documentation
    //status
    if tempIMM <> '' then
      begin
        name := Piece(tempIMM, U, 2);
        idx := cboImm.items.indexOf(name);
        if idx = -1 then exit;
        cboImm.itemIndex := idx;
        cboImm.text := name;
        selectPage(cboImm.Items.Strings[idx], false, false);
      end;
  finally
    FreeAndNil(tmpList);
  end;
end;

procedure TfraVimmSelect.rgpDocumentationEnter(Sender: TObject);
begin
  inherited;
  rgpDocumentation.Tag := rgpDocumentation.ItemIndex;
end;

//called
procedure TfraVimmSelect.selectPage(data: string; details, edit: boolean);
var
aControl: TControl;
warn: integer;
needsOverride: boolean;
layout: integer;
documType: string;
begin
  aControl := getEditControl;
  needsOverride := false;
  if details = true then
    begin
//      TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgDetails, data, edit, needsOverride);
      TFraImmEdit(aControl).createLayout(4, '', data, true, false);
      btnExpandCollapseClick(self);
      exit;
    end;
  isEditing := true;
  if (rgpDocumentation.ItemIndex = 0) and (cboImm.ItemIndex > -1) and (not isSkinTest) then
    begin
      warn := performCheck(cboImm.Items.Strings[cboImm.ItemIndex], self.patientIEN);
      if warn = -1 then exit
      else if warn = 1 then needsOverride := true;
  end;
  layout := getLayoutValue;
  documType := getDocumentType;
  if (edit = false) and (not editingRecord) then
    begin
      if hasVimmResult(data, documType) then
        begin
          ShowMessage('Cannot add more than one record with the same documentation Type');
          exit;
        end;


    end;
  TFraImmEdit(aControl).createLayout(layout, documType, data, edit, needsOverride);
end;

//set initial edit values either from the grid or the main form
//for first time new immunization entry. Most likely have the immunization but not the
//documentation status
function TfraVimmSelect.setEditFields(immunization: string): boolean;
var
vid,name,documType: string;
idx: integer;
tmpList: TStringList;
begin
  result := false;
  tempImm := '';
  vid := Piece(immunization, U, 1);
  name := Piece(immunization, U, 2);
  documType := Piece(immunization, u, 3);
  if name = genericIMM then
    begin
      if uVimmInputs.documentType = '0' then documType := 'Administered'
      else if uVimmInputs.documentType = '1' then documType := 'Historical'
    end;
  if documType = '' then
    begin
      tempImm := immunization;
      result := true;
      rgpDocumentation.Enabled := true;
      exit;
    end;
    idx := rgpDocumentation.Items.IndexOf('&' + documType);
    if idx = -1 then
      begin
        showMessage(documType + 'not found in the documenation Type list.');
        exit;
      end;
    rgpDocumentation.ItemIndex := idx;
    rgpDocumentationClick(rgpDocumentation);
    if cboImm.Items.Count = 0 then
    begin
      tmpList := TStringLIst.Create;
      try
        getShortActiveLookup(tmpList, true, not editingRecord);
        FastAssign(tmpList, cboImm.Items);
      finally
        FreeAndNil(tmpList);
      end;
    end;
  if name <> genericIMM then
    begin
      idx := cboImm.items.indexOf(name);
      if idx = -1 then
        begin
          showMessage(name + ' not found in the immunization list.');
          exit;
        end;
      cboImm.itemIndex := idx;
      cboImm.Enabled := false;
      result := true;
    end
    else
      begin
        cboImm.itemIndex := -1;
        cboImm.Enabled := true;
//        result := true;
      end;
end;

//procedure to set encounter data from the form
procedure TfraVimmSelect.setEncounterData(date: TFMDateTime; patient: string; isSkin: boolean);
begin
  isSkinTest := isSkin;
  self.adminDate := date;
  self.patientIEN := patient;
  getIMMShortList(date, isSkinTest);
end;

procedure TfraVimmSelect.setSelectionType(isSkin: boolean);
begin
//  if isSkin then self.pgeSelector.ActivePage := pgSkin
//  else self.pgeSelector.ActivePage := pgImm;
  isSkinTest := isSkin;
  if isSkinTest then
      begin
        lblImm.Caption := 'Select a Skin Test';
        rgpDocumentation.Items.Clear;
        if uVimmInputs.isFromEncounter and uVimmInputs.isHistorical then
          rgpDocumentation.Items.Add('&Historical')
        else if uVimmInputs.isFromEncounter then
          begin
            rgpDocumentation.Items.Add('&Administered');
            rgpDocumentation.Items.Add('&Reading');
//            rgpDocumentation.Items.Add('&Historical');
          end
        else
          begin
            rgpDocumentation.Items.Add('&Administered');
            rgpDocumentation.Items.Add('&Reading');
            rgpDocumentation.Items.Add('&Historical');
          end;
      end
  else
      begin
        lblImm.Caption := 'Select an Immunization';
        rgpDocumentation.Items.Clear;
        if uVimmInputs.isFromEncounter and uVimmInputs.isHistorical then
          begin
            rgpDocumentation.Items.Add('&Historical');
            rgpDocumentation.Items.Add('&Contraindication');
            rgpDocumentation.Items.Add('&Refused');
          end
        else if uVimmInputs.isFromEncounter then
          begin
            rgpDocumentation.Items.Add('&Administered');
            rgpDocumentation.Items.Add('&Contraindication');
            rgpDocumentation.Items.Add('&Refused');
          end
        else
          begin
            rgpDocumentation.Items.Add('&Administered');
            rgpDocumentation.Items.Add('&Historical');
            rgpDocumentation.Items.Add('&Contraindication');
            rgpDocumentation.Items.Add('&Refused');
          end;
      end;
end;

//edit process called form the immunization grid frame. Use when the grid is showing
procedure TfraVimmSelect.startEdits(data: string = ''; details: boolean = false; edit: boolean = true);
begin
  if self.fCollapsed then self.expand;
  rgpDocumentation.Enabled := true;
  editingRecord := edit;
  if isSkinTest and ((uVimmInputs.documentType = '0') or (uVimmInputs.documentType = '')) and (not editingRecord)  then
    begin
      if placementsOnFile then self.rgpDocumentation.ItemIndex := 1
      else self.rgpDocumentation.ItemIndex := 0;
    end;

  if (data <> '') and (details = false) and (not setEditFields(data)) then exit;
  if data <> '' then selectPage(data, details, edit);
end;

//edit process called from the form. This is used when the the immunization grid does not show in the form
function TfraVimmSelect.startEditsFromMain(data: string; edit: boolean): boolean;
var
documentType: string;
begin
   result := true;
   documentType :=  Piece(data, U, 3);
    if documentType <> '' then
      begin
        documentType := Copy(self.rgpDocumentation.Items.Strings[StrToInt(documentType)], 2,
          Length(self.rgpDocumentation.Items.Strings[StrToInt(documentType)]));
        setPiece(data, U, 3, documentType);
      end;
   if not setEditFields(data) then
    begin
      result := false;
      exit;
    end;

    self.spBtnExpandCollapse.Visible := false;
    self.lblHeader.Left := 5;
    if cboImm.ItemIndex > -1 then
        begin
          self.lblHeader.Caption := Piece(self.cboImm.Items.Strings[self.cboImm.ItemIndex], U, 2) + ' ' + documentType + ' documentation';
          self.gridPanel.ColumnCollection.BeginUpdate;
          self.gridPanel.ColumnCollection[0].Value := 0;
          self.gridPanel.ColumnCollection[1].Value := 100;
          self.gridPanel.ColumnCollection.EndUpdate;
          cboImm.Enabled := false;
        end;
    selectPage(data, false, edit);
end;

procedure TfraVimmSelect.startFromIce(input: string);
begin
  iceData := input;
  rgpDocumentation.ItemIndex := 0;
  rgpDocumentationClick(rgpDocumentation);
end;

procedure TfraVimmSelect.startFromReminders(input: string);
begin
  remId := input;
  rgpDocumentation.ItemIndex := 0;
  rgpDocumentationClick(rgpDocumentation);
end;

end.
